@extends('layouts.app')

@section('title', 'Patient Registration')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-500 to-blue-700 py-8">
    <div class="max-w-2xl w-full bg-white rounded-lg shadow-xl p-8 mx-4">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800">Patient Registration</h1>
            <p class="text-gray-600 mt-2">Create your account to access your prescriptions and appointments</p>
        </div>

        <form method="POST" action="{{ route('patient.register') }}">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <select name="title" class="w-full px-3 py-2 border rounded">
                        <option value="">Select</option>
                        <option value="Mr">Mr</option>
                        <option value="Mrs">Mrs</option>
                        <option value="Ms">Ms</option>
                        <option value="Dr">Dr</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" value="{{ old('first_name') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" value="{{ old('last_name') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Date of Birth *</label>
                    <input type="date" name="date_of_birth" value="{{ old('date_of_birth') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Gender *</label>
                    <select name="gender" required class="w-full px-3 py-2 border rounded">
                        <option value="">Select</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                        <option value="Other">Other</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Identity Number</label>
                    <input type="text" name="identity_number" value="{{ old('identity_number') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone Area Code</label>
                    <input type="text" name="phone_area_code" value="{{ old('phone_area_code') }}" placeholder="+266" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone Number *</label>
                    <input type="text" name="phone_number" value="{{ old('phone_number') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                    <input type="email" name="email" value="{{ old('email') }}" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Payment Mode *</label>
                    <select name="payment_mode" id="payment_mode" required class="w-full px-3 py-2 border rounded">
                        <option value="Cash Payment">Cash Payment</option>
                        <option value="Medical Aid Payment">Medical Aid Payment</option>
                    </select>
                </div>

                <div id="medical_aid_fields" class="hidden">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Medical Aid Number *</label>
                    <input type="text" name="medical_aid_number" value="{{ old('medical_aid_number') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div id="main_member_fields" class="hidden">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Main Member</label>
                    <input type="text" name="main_member" value="{{ old('main_member') }}" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Password *</label>
                    <input type="password" name="password" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Confirm Password *</label>
                    <input type="password" name="password_confirmation" required class="w-full px-3 py-2 border rounded">
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg">
                    Register
                </button>
            </div>

            <div class="mt-4 text-center">
                <a href="{{ route('login') }}" class="text-blue-600 hover:text-blue-800">
                    Already have an account? Login here
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('payment_mode').addEventListener('change', function() {
    const medicalAidFields = document.getElementById('medical_aid_fields');
    const mainMemberFields = document.getElementById('main_member_fields');
    
    if (this.value === 'Medical Aid Payment') {
        medicalAidFields.classList.remove('hidden');
        mainMemberFields.classList.remove('hidden');
        medicalAidFields.querySelector('input').required = true;
    } else {
        medicalAidFields.classList.add('hidden');
        mainMemberFields.classList.add('hidden');
        medicalAidFields.querySelector('input').required = false;
    }
});
</script>
@endsection

